/*
 * Decompiled with CFR 0.152.
 */
package net.impactdev.impactor.relocations.com.mongodb.connection;

import java.nio.channels.AsynchronousChannelGroup;
import net.impactdev.impactor.relocations.com.mongodb.ServerAddress;
import net.impactdev.impactor.relocations.com.mongodb.assertions.Assertions;
import net.impactdev.impactor.relocations.com.mongodb.connection.BufferProvider;
import net.impactdev.impactor.relocations.com.mongodb.connection.SocketSettings;
import net.impactdev.impactor.relocations.com.mongodb.connection.SslSettings;
import net.impactdev.impactor.relocations.com.mongodb.connection.Stream;
import net.impactdev.impactor.relocations.com.mongodb.connection.StreamFactory;
import net.impactdev.impactor.relocations.com.mongodb.internal.connection.AsynchronousSocketChannelStream;
import net.impactdev.impactor.relocations.com.mongodb.internal.connection.PowerOfTwoBufferPool;

public class AsynchronousSocketChannelStreamFactory
implements StreamFactory {
    private final BufferProvider bufferProvider = new PowerOfTwoBufferPool();
    private final SocketSettings settings;
    private final AsynchronousChannelGroup group;

    public AsynchronousSocketChannelStreamFactory(SocketSettings settings, SslSettings sslSettings) {
        this(settings, sslSettings, null);
    }

    public AsynchronousSocketChannelStreamFactory(SocketSettings settings, SslSettings sslSettings, AsynchronousChannelGroup group) {
        if (sslSettings.isEnabled()) {
            throw new UnsupportedOperationException("No SSL support in java.nio.channels.AsynchronousSocketChannel. For SSL support use com.mongodb.connection.netty.NettyStreamFactoryFactory");
        }
        this.settings = Assertions.notNull("settings", settings);
        this.group = group;
    }

    @Override
    public Stream create(ServerAddress serverAddress) {
        return new AsynchronousSocketChannelStream(serverAddress, this.settings, this.bufferProvider, this.group);
    }
}

